unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, Menus, StdCtrls;

type
  TMainForm = class(TForm)
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    MainMenu1: TMainMenu;
    Akcja1: TMenuItem;
    Podajzaznaczone1: TMenuItem;
    Koniecpracy1: TMenuItem;
    StatusBar1: TStatusBar;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Koniecpracy1Click(Sender: TObject);
    procedure Podajzaznaczone1Click(Sender: TObject);
  private

  public
    procedure Info();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	info();
end;

procedure TMainForm.Koniecpracy1Click(Sender: TObject);
begin
	if Application.MessageBox('Koniec pracy?', 'Uwaga', MB_YESNO or MB_ICONQUESTION) = mrYes then
	begin
		Close();
	end;
end;

procedure TMainForm.Podajzaznaczone1Click(Sender: TObject);
begin
	info();
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
	CheckBox1.Checked := true;
end;

procedure TMainForm.Info();
var
	kom : String;

begin
	kom := 'Zaznaczone:' + #10#13;

	if CheckBox1.Checked then
   begin
		kom := kom + 'e-mail' + #10#13;
   end;

	if CheckBox2.Checked then
   begin
		kom := kom + 'sms' + #10#13;
   end;

	if CheckBox3.Checked then
   begin
		kom := kom + 'fax' + #10#13;
   end;

   ShowMessage(kom);
end;

end.
